% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program CSFcostfunc.m
function L = CSFcostfunc(guess, data)

Gmax = guess(1);
Fmax = guess(2);
beta = guess(3);
delta = guess(4);
f = data(1, :);
S_observed = log10(data(2, :));
Nfrequencies = size(data, 2); 
        % # of spatial frequency conditions

S_predicted = [];
for i=1:Nfrequencies    
    S = log10(Gmax) - log10(2) * ((log10(f(i)) - ...
        log10(Fmax))/(log10(2*beta)/2))^2;
    if (f(i) >= Fmax)
        S = S;
    elseif (f(i) < Fmax & S < log10(Gmax) - delta)
        S = log10(Gmax) - delta;
    end
    S_predicted = [ S_predicted S ];
end
        
L = sum( (S_observed - S_predicted).^2 );
